/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.util.zipdir;

import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.base.util.zipdir.ZipDirDirectory;
import com.ibm.hwmca.base.util.zipdir.ZipDirPartition;
import com.ibm.hwmca.base.util.zipdir.ZipDirXMLParser;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.persist.Persistable;
import com.ibm.hwmca.fw.persist.PersistenceManager;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.util.MalformedXMLException;
import com.ibm.hwmca.fw.util.Trace;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public abstract class ZipDirManager
implements Persistable {
    private static final String TRACE_MASKT = "XZIPMGRT";
    private static final String TRACE_MASKF = "XZIPMGRF";
    private static final String TRACE_MASKD = "XZIPMGRD";
    private String partitionKey = "";
    public static final String ZIPDIR_XML = "zipdir.xml";
    public static final String ZIPDIR_ROOT = "zipdir";
    private static String xmlPath = null;
    private static String zipDirRootPath = null;
    protected ZipDirPartition zdp = null;
    protected static final long DAYS_TO_MILLIS = 86400000L;
    private PersistenceManager pm = PersistenceManager.getPersistenceManager();
    private static final String PERSISTENCE_KEY = "com.ibm.hwmca.base.util.zipdir";

    public ZipDirManager() {
        Trace.trace(TRACE_MASKD, "<-> ZipDirManager.ctor");
    }

    public ZipDirManager(String _partitionKey) throws HException {
        Trace.trace(TRACE_MASKD, "<-> ZipDirManager.ctor:" + _partitionKey);
        this.partitionKey = _partitionKey;
        if (xmlPath == null) {
            try {
                xmlPath = BaseFileControl.getFilePath(ZIPDIR_XML);
            }
            catch (HException e) {
                Trace.trace(TRACE_MASKT, "Exception trying to find filepath for 'zipdir.xml' (partitions will be built with key as root)");
                Trace.trace(TRACE_MASKT, e);
            }
        }
        if (zipDirRootPath == null) {
            try {
                zipDirRootPath = BaseFileControl.getFilePath(ZIPDIR_ROOT);
            }
            catch (HException e) {
                Trace.trace(TRACE_MASKT, "Exception trying to find filepath for 'zipdir'");
                Trace.trace(TRACE_MASKT, e);
                throw e;
            }
            Trace.trace(TRACE_MASKF, "Using '" + zipDirRootPath + "' for zipdir root path");
            File zipDirRootDir = new File(zipDirRootPath);
            if (!zipDirRootDir.exists()) {
                zipDirRootDir.mkdirs();
            }
        }
        try {
            if (this.pm.contains("com.ibm.hwmca.base.util.zipdir." + this.partitionKey)) {
                Trace.trace(TRACE_MASKD, "reconstituting partition from persistent data");
                this.reconstitute((PersistentData)this.pm.read("com.ibm.hwmca.base.util.zipdir." + this.partitionKey));
                return;
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "Exception using PersistenceManager (will rebuild partition)");
            Trace.trace(TRACE_MASKT, e);
        }
        if (this.zdp == null && xmlPath != null) {
            try {
                this.zdp = ZipDirXMLParser.parseXML(xmlPath + ZIPDIR_XML, this.partitionKey);
                if (this.zdp == null) {
                    Trace.trace(TRACE_MASKT, "Partition key not found in '" + xmlPath + ZIPDIR_XML + "' (build default partition with key as root)");
                }
            }
            catch (MalformedXMLException e) {
                Trace.trace(TRACE_MASKT, "'" + xmlPath + ZIPDIR_XML + "' malformed (build default partition with key as root)");
                Trace.trace(TRACE_MASKT, e);
            }
        }
        if (this.zdp == null) {
            this.zdp = new ZipDirPartition(this.partitionKey);
        }
        this.zdp.setRootPath(zipDirRootPath + this.zdp.getRoot() + "/");
        File partitionRootDir = new File(this.zdp.getRootPath());
        if (!partitionRootDir.exists()) {
            Trace.trace(TRACE_MASKF, "creating partition root: '" + this.zdp.getRootPath() + "'");
            partitionRootDir.mkdirs();
        }
        this.persist();
    }

    public ZipDirManager(PersistentData data) {
        this.reconstitute(data);
    }

    public void finalize() {
        Trace.trace(TRACE_MASKD, "<->finalize");
        this.pm.delete("com.ibm.hwmca.base.util.zipdir." + this.partitionKey);
    }

    public PersistentData getPersistentData() {
        return this.zdp;
    }

    public boolean isUpgradeData() {
        return false;
    }

    private void persist() {
        try {
            this.pm.write("com.ibm.hwmca.base.util.zipdir." + this.partitionKey, this.getPersistentData());
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "Exception using PersistenceManager");
            Trace.trace(TRACE_MASKT, e);
        }
    }

    private void reconstitute(PersistentData data) {
        this.zdp = (ZipDirPartition)data;
    }

    public String queryPartitionPath() {
        return this.zdp.getRootPath();
    }

    public String queryDirectoryPath(String dirKey) {
        return this.queryPartitionPath() + dirKey + "/";
    }

    public int queryDirectorySize(String dirKey) throws HException {
        File partitionDirFile = new File(this.queryDirectoryPath(dirKey));
        if (!partitionDirFile.exists()) {
            Trace.trace(TRACE_MASKT, "queryDirectorySize: directory for '" + dirKey + "' (" + this.queryDirectoryPath(dirKey) + ") not found");
            throw new HException(new FileNotFoundException("directory '" + this.queryDirectoryPath(dirKey) + "' not found"));
        }
        String[] partitionFilenames = partitionDirFile.list();
        long size = 0L;
        int i = 0;
        while (i < partitionFilenames.length) {
            size += new File(partitionDirFile, partitionFilenames[i]).length();
            ++i;
        }
        return (int)size;
    }

    public ArrayList queryFiles(String dirKey) throws HException {
        String partitionDirPath = this.queryDirectoryPath(dirKey);
        File partitionDirFile = new File(partitionDirPath);
        if (!partitionDirFile.exists()) {
            Trace.trace(TRACE_MASKT, "queryFiles: directory for '" + dirKey + "' (" + partitionDirPath + ") not found");
            throw new HException(new FileNotFoundException("directory '" + this.queryDirectoryPath(dirKey) + "' not found"));
        }
        String[] partitionFilenames = partitionDirFile.list();
        if (partitionFilenames.length == 0) {
            Trace.trace(TRACE_MASKF, "queryFiles: no files found in directory for '" + dirKey + "'");
            return new ArrayList();
        }
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < partitionFilenames.length) {
            list.add(partitionFilenames[i]);
            ++i;
        }
        return list;
    }

    public ArrayList queryFilesAbsolute(String dirKey) throws HException {
        String partitionDirPath = this.queryDirectoryPath(dirKey);
        File partitionDirFile = new File(partitionDirPath);
        if (!partitionDirFile.exists()) {
            Trace.trace(TRACE_MASKT, "queryFilesAbsolute: directory for '" + dirKey + "' (" + partitionDirPath + ") not found");
            throw new HException(new FileNotFoundException("directory '" + this.queryDirectoryPath(dirKey) + "' not found"));
        }
        String[] partitionFilenames = partitionDirFile.list();
        if (partitionFilenames.length == 0) {
            Trace.trace(TRACE_MASKF, "queryFilesAbsolute: no files found in directory for '" + dirKey + "'");
            return new ArrayList();
        }
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < partitionFilenames.length) {
            list.add(partitionDirPath + partitionFilenames[i]);
            ++i;
        }
        return list;
    }

    public synchronized String createDirectory(String dirKey) {
        ZipDirDirectory zdd = this.zdp.getDirectory(dirKey);
        if (zdd != null) {
            Trace.trace(TRACE_MASKD, "createDirectory: directory for '" + dirKey + "' already exists");
            return this.queryDirectoryPath(dirKey);
        }
        File newDirFile = new File(this.queryDirectoryPath(dirKey));
        if (newDirFile.exists()) {
            Trace.trace(TRACE_MASKD, "createDirectory: directory for '" + dirKey + "' already exists (but not part of ZipDir partition)");
            return this.queryDirectoryPath(dirKey);
        }
        ArrayList dirList = this.zdp.getDirectoryList();
        int pruneCount = dirList.size() - (this.zdp.getMaxDirs() - 1);
        Trace.trace(TRACE_MASKD, "createDirectory: pruneCount=" + pruneCount);
        int pruned = 0;
        while (pruned < pruneCount) {
            ZipDirDirectory deleteDir = null;
            boolean foundOne = false;
            deleteDir = (ZipDirDirectory)dirList.get(0);
            Calendar currTime = Calendar.getInstance();
            if (currTime.getTimeInMillis() - deleteDir.getCreationTime().getTimeInMillis() > (long)this.zdp.getDaysToKeep() * 86400000L) {
                foundOne = true;
            }
            if (!foundOne && this.zdp.getNumDataOffloaded() > 0) {
                int i = 0;
                while (i < dirList.size()) {
                    deleteDir = (ZipDirDirectory)dirList.get(i);
                    if (deleteDir.isDataOffloaded()) {
                        foundOne = true;
                        break;
                    }
                    ++i;
                }
            }
            if (!foundOne) {
                deleteDir = (ZipDirDirectory)dirList.get(1);
            }
            Trace.trace(TRACE_MASKF, "createDirectory: removing directory for '" + deleteDir.getKey() + "'");
            this.deleteFile(new File(this.queryDirectoryPath(deleteDir.getKey())));
            this.zdp.removeDirectory(deleteDir);
            ++pruned;
        }
        Trace.trace(TRACE_MASKF, "createDirectory: creating directory for '" + dirKey + "'");
        newDirFile.mkdirs();
        this.zdp.addDirectory(dirKey);
        this.persist();
        return this.queryDirectoryPath(dirKey);
    }

    public void removeDirectory(String dirKey) {
        File dirFile = new File(this.queryDirectoryPath(dirKey));
        if (!dirFile.exists()) {
            Trace.trace(TRACE_MASKD, "removeDirectory: '" + this.queryDirectoryPath(dirKey) + "' does not exist");
            return;
        }
        this.deleteFile(dirFile);
        ZipDirDirectory zdd = this.zdp.getDirectory(dirKey);
        if (zdd != null) {
            this.zdp.removeDirectory(zdd);
            this.persist();
        }
    }

    public void copyToDirectory(String dirKey, String file) throws HException {
        File sourceFile = new File(file);
        if (!sourceFile.exists()) {
            Trace.trace(TRACE_MASKT, "copyToDirectory: file '" + file + "' not found");
            throw new HException(new FileNotFoundException("file '" + file + "' not found"));
        }
        String destPath = this.queryDirectoryPath(dirKey);
        File destDirFile = new File(destPath);
        if (!destDirFile.exists()) {
            Trace.trace(TRACE_MASKT, "copyToDirectory: directory '" + destPath + "' not found");
            throw new HException(new FileNotFoundException("directory '" + destPath + "' not found"));
        }
        try {
            File destFile = new File(destPath + this.trimPath(file));
            Trace.trace(TRACE_MASKD, "copyToDirectory: copying '" + sourceFile.getPath() + "' to '" + destFile.getPath() + "'");
            FileInputStream fis = new FileInputStream(sourceFile);
            FileOutputStream fos = new FileOutputStream(destFile);
            byte[] buffer = new byte[1024];
            int bytesRead = 0;
            while ((bytesRead = fis.read(buffer)) != -1) {
                fos.write(buffer, 0, bytesRead);
            }
            fos.close();
            fis.close();
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "copyToDirectory: caught exception");
            Trace.trace(TRACE_MASKT, e);
            throw new HException(e);
        }
    }

    public void copyToDirectory(String dirKey, List fileList) throws HException {
        Iterator iter = fileList.iterator();
        while (iter.hasNext()) {
            this.copyToDirectory(dirKey, (String)iter.next());
        }
    }

    public void moveToDirectory(String dirKey, String file) throws HException {
        this.copyToDirectory(dirKey, file);
        new File(file).delete();
    }

    public void moveToDirectory(String dirKey, List fileList) throws HException {
        Iterator iter = fileList.iterator();
        while (iter.hasNext()) {
            this.moveToDirectory(dirKey, (String)iter.next());
        }
    }

    public void removeFromDirectory(String dirKey, String file) {
        File remFile = new File(this.queryDirectoryPath(dirKey) + file);
        if (!remFile.exists()) {
            Trace.trace(TRACE_MASKT, "removeFileFromDirectory: file '" + remFile.getPath() + "' not found");
            return;
        }
        remFile.delete();
    }

    public void removeFromDirectory(String dirKey, List fileList) {
        Iterator iter = fileList.iterator();
        File remFile = null;
        while (iter.hasNext()) {
            remFile = new File(this.queryDirectoryPath(dirKey) + iter.next());
            if (!remFile.exists()) {
                Trace.trace(TRACE_MASKT, "removeFileFromDirectory: file '" + remFile.getPath() + "' not found");
                continue;
            }
            remFile.delete();
        }
    }

    public String queryZipName(String dirKey) {
        return this.queryDirectoryPath(dirKey) + dirKey + ".zip";
    }

    public int queryZipSize(String dirKey) throws HException {
        File zipFile = new File(this.queryZipName(dirKey));
        if (!zipFile.exists()) {
            Trace.trace(TRACE_MASKT, "queryZipSize: zip file for '" + dirKey + "' (" + this.queryZipName(dirKey) + ") not found");
            throw new HException(new FileNotFoundException("file '" + this.queryZipName(dirKey) + "' not found"));
        }
        return (int)zipFile.length();
    }

    public ArrayList queryZipFiles(String dirKey) throws HException {
        ZipFile zf = this.getZipFile(dirKey);
        if (zf == null) {
            Trace.trace(TRACE_MASKT, "queryZipFiles: no zipfile");
            throw new HException(new FileNotFoundException("zip file '" + this.queryZipName(dirKey) + "' not found"));
        }
        Enumeration<? extends ZipEntry> entries = zf.entries();
        if (!entries.hasMoreElements()) {
            Trace.trace(TRACE_MASKF, "queryZipFiles: empty zipfile");
            return new ArrayList();
        }
        ArrayList<String> list = new ArrayList<String>();
        while (entries.hasMoreElements()) {
            list.add(entries.nextElement().getName());
        }
        return list;
    }

    public void addToZip(String dirKey, String file, boolean replace, boolean absolute) throws HException {
        ArrayList<String> a = new ArrayList<String>();
        a.add(file);
        this.addToZip(dirKey, a, replace, absolute);
    }

    public void addToZip(String dirKey, List fileList, boolean replace, boolean absolute) throws HException {
        int i;
        String destPath = this.queryDirectoryPath(dirKey);
        File destDirFile = new File(destPath);
        if (!destDirFile.exists()) {
            Trace.trace(TRACE_MASKT, "addToZip: directory '" + destPath + "' not found");
            throw new HException(new FileNotFoundException("directory '" + destPath + "' not found"));
        }
        File newZip = null;
        ZipOutputStream zos = null;
        try {
            newZip = new File(this.queryZipName(dirKey) + ".new");
            zos = new ZipOutputStream(new FileOutputStream(newZip));
            zos.setMethod(8);
            zos.setLevel(-1);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "Exception trying to open new zipfile");
            Trace.trace(TRACE_MASKT, e);
            throw new HException(e);
        }
        ArrayList<String> oldFilenameList = new ArrayList<String>();
        ZipFile oldZip = null;
        try {
            oldZip = this.getZipFile(dirKey);
        }
        catch (HException e) {
            return;
        }
        if (oldZip != null) {
            Object[] filenames = new String[fileList.size()];
            i = 0;
            while (i < fileList.size()) {
                filenames[i] = absolute ? (String)fileList.get(i) : this.trimPath((String)fileList.get(i));
                ++i;
            }
            Arrays.sort(filenames);
            try {
                Enumeration<? extends ZipEntry> enumeration = oldZip.entries();
                while (enumeration.hasMoreElements()) {
                    ZipEntry ze = enumeration.nextElement();
                    if (replace && Arrays.binarySearch(filenames, ze.getName()) >= 0) {
                        Trace.trace(TRACE_MASKD, "addToZip: skipping old entry '" + ze.getName() + "' (being replaced)");
                        continue;
                    }
                    Trace.trace(TRACE_MASKD, "addToZip: copying old entry '" + ze.getName() + "'...");
                    oldFilenameList.add(ze.getName());
                    InputStream is = oldZip.getInputStream(ze);
                    this.zip(is, ze, zos);
                    is.close();
                }
                oldZip.close();
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKT, "Exception trying to copy to zipfile");
                Trace.trace(TRACE_MASKT, e);
                throw new HException(e);
            }
        }
        Object[] oldFilenames = null;
        if (oldFilenameList.size() == 0) {
            replace = true;
        } else {
            oldFilenames = new String[oldFilenameList.size()];
            i = 0;
            while (i < oldFilenameList.size()) {
                oldFilenames[i] = (String)oldFilenameList.get(i);
                ++i;
            }
            Arrays.sort(oldFilenames);
        }
        try {
            Iterator iter = fileList.iterator();
            while (iter.hasNext()) {
                String filename = (String)iter.next();
                String zipname = null;
                zipname = absolute ? filename : this.trimPath(filename);
                if (!replace && Arrays.binarySearch(oldFilenames, zipname) >= 0) continue;
                File sourceFile = new File(filename);
                if (!sourceFile.exists()) {
                    Trace.trace(TRACE_MASKT, "addToZip: file '" + filename + "' not found");
                    throw new FileNotFoundException("file '" + filename + "' not found");
                }
                Trace.trace(TRACE_MASKD, "addToZip: adding '" + zipname + "'...");
                FileInputStream fis = new FileInputStream(sourceFile);
                this.zip(fis, new ZipEntry(zipname), zos);
                fis.close();
            }
            zos.close();
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "Exception trying to add to zipfile");
            Trace.trace(TRACE_MASKT, e);
            throw new HException(e);
        }
        if (oldZip != null) {
            File oldZipFile = new File(this.queryZipName(dirKey));
            oldZipFile.delete();
        }
        newZip.renameTo(new File(this.queryZipName(dirKey)));
    }

    public void moveToZip(String dirKey, String file, boolean replace, boolean absolute) throws HException {
        this.addToZip(dirKey, file, replace, absolute);
        new File(file).delete();
    }

    public void moveToZip(String dirKey, List fileList, boolean replace, boolean absolute) throws HException {
        this.addToZip(dirKey, fileList, replace, absolute);
        Iterator iter = fileList.iterator();
        while (iter.hasNext()) {
            new File((String)iter.next()).delete();
        }
    }

    public void removeFromZip(String dirKey, String file) throws HException {
        ArrayList<String> a = new ArrayList<String>();
        a.add(file);
        this.removeFromZip(dirKey, a);
    }

    public void removeFromZip(String dirKey, List fileList) throws HException {
        ZipFile oldZip = null;
        try {
            oldZip = this.getZipFile(dirKey);
        }
        catch (HException e) {
            return;
        }
        if (oldZip == null) {
            Trace.trace(TRACE_MASKT, "removeFromZip: no zipfile");
            throw new HException(new FileNotFoundException("file '" + this.queryZipName(dirKey) + "' not found"));
        }
        try {
            Object[] filenames = new String[fileList.size()];
            int i = 0;
            while (i < fileList.size()) {
                filenames[i] = (String)fileList.get(i);
                ++i;
            }
            Arrays.sort(filenames);
            File newZip = new File(this.queryZipName(dirKey) + ".new");
            ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(newZip));
            zos.setMethod(8);
            zos.setLevel(-1);
            Enumeration<? extends ZipEntry> enumeration = oldZip.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry ze = enumeration.nextElement();
                if (Arrays.binarySearch(filenames, ze.getName()) < 0) {
                    Trace.trace(TRACE_MASKD, "removeFromZip: keeping '" + ze.getName() + "'...");
                    InputStream is = oldZip.getInputStream(ze);
                    this.zip(is, ze, zos);
                    is.close();
                    continue;
                }
                Trace.trace(TRACE_MASKD, "removeFromZip: removing '" + ze.getName() + "'...");
            }
            zos.close();
            oldZip.close();
            File oldZipFile = new File(this.queryZipName(dirKey));
            oldZipFile.delete();
            newZip.renameTo(new File(this.queryZipName(dirKey)));
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "Exception trying to update zipfile");
            Trace.trace(TRACE_MASKT, e);
            throw new HException(e);
        }
    }

    public void removeZip(String dirKey) {
        this.removeFromDirectory(dirKey, this.trimPath(this.queryZipName(dirKey)));
    }

    public void dataOffloaded(String dirKey) throws HException {
        ZipDirDirectory zdd = this.zdp.getDirectory(dirKey);
        if (zdd != null) {
            zdd.setDataOffloaded(true);
            this.zdp.setNumDataOffloaded(this.zdp.getNumDataOffloaded() + 1);
            this.persist();
            return;
        }
        Trace.trace(TRACE_MASKT, "dataOffloaded: ZipDirDirectory object not found for '" + dirKey + "'");
        throw new HException(new FileNotFoundException("directory '" + this.queryDirectoryPath(dirKey) + "' not found"));
    }

    public boolean isDataOffloaded(String dirKey) {
        if (this.zdp.getNumDataOffloaded() == 0) {
            return false;
        }
        ZipDirDirectory zdd = this.zdp.getDirectory(dirKey);
        if (zdd != null) {
            return zdd.isDataOffloaded();
        }
        Trace.trace(TRACE_MASKT, "isDataOffloaded: ZipDirDirectory object not found for '" + dirKey + "'");
        return false;
    }

    private void deleteFile(File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            int i = 0;
            while (i < files.length) {
                this.deleteFile(files[i]);
                ++i;
            }
        }
        file.delete();
    }

    private String trimPath(String file) {
        return file.substring(file.lastIndexOf(47) + 1);
    }

    private ZipFile getZipFile(String dirKey) throws HException {
        File f = new File(this.queryZipName(dirKey));
        if (!f.exists()) {
            Trace.trace(TRACE_MASKT, "getZipFile: zipfile for '" + dirKey + "' not found");
            return null;
        }
        ZipFile zf = null;
        try {
            zf = new ZipFile(f);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "Exception trying to access zipfile");
            Trace.trace(TRACE_MASKT, e);
            throw new HException(e);
        }
        return zf;
    }

    private void zip(InputStream is, ZipEntry ze, ZipOutputStream zos) throws Exception {
        zos.putNextEntry(ze);
        byte[] buffer = new byte[1024];
        int bytesRead = 0;
        while ((bytesRead = is.read(buffer)) != -1) {
            zos.write(buffer, 0, bytesRead);
        }
    }
}

